# ramsey/collection

[![Source Code][badge-source]][source]
[![Latest Version][badge-release]][release]
[![Software License][badge-license]][license]
[![Build Status][badge-build]][build]
[![Coverage Status][badge-coverage]][coverage]
[![Total Downloads][badge-downloads]][downloads]

ramsey/collection is a PHP 7.2+ library for representing and manipulating collections..

This project adheres to a [Contributor Code of Conduct][conduct]. By participating in this project and its community, you are expected to uphold this code.


## About

Much inspiration for this library came from the [Java Collections Framework][java].


## Installation

The preferred method of installation is via [Packagist][] and [Composer][]. Run
the following command to install the package and add it as a requirement to
your project's `composer.json`:

```bash
composer require ramsey/collection
```


## API documentation

The [latest class API documentation][apidocs] is available online.


## Examples

Examples of how to use this framework can be found in the [Wiki pages](https://github.com/ramsey/collection/wiki/Examples).


## Contributing

Contributions are welcome! Please read [CONTRIBUTING][] for details.


## Copyright and License

The ramsey/collection library is copyright © [Ben Ramsey](https://benramsey.com/) and licensed for use under the MIT License (MIT). Please see [LICENSE][] for more information.



[conduct]: https://github.com/ramsey/collection/blob/master/.github/CODE_OF_CONDUCT.md
[java]: http://docs.oracle.com/javase/8/docs/technotes/guides/collections/index.html
[packagist]: https://packagist.org/packages/ramsey/collection
[composer]: http://getcomposer.org/
[apidocs]: https://docs.benramsey.com/ramsey-collection/latest/
[contributing]: https://github.com/ramsey/collection/blob/master/.github/CONTRIBUTING.md

[badge-source]: http://img.shields.io/badge/source-ramsey/collection-blue.svg?style=flat-square
[badge-release]: https://img.shields.io/github/release/ramsey/collection.svg?style=flat-square
[badge-license]: https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat-square
[badge-build]: https://img.shields.io/travis/ramsey/collection/master.svg?style=flat-square
[badge-coverage]: https://img.shields.io/coveralls/ramsey/collection/master.svg?style=flat-square
[badge-downloads]: https://img.shields.io/packagist/dt/ramsey/collection.svg?style=flat-square

[source]: https://github.com/ramsey/collection
[release]: https://github.com/ramsey/collection/releases
[license]: https://github.com/ramsey/collection/blob/master/LICENSE
[build]: https://travis-ci.org/ramsey/collection
[hhvm]: http://hhvm.h4cc.de/package/ramsey/collection
[coverage]: https://coveralls.io/r/ramsey/collection?branch=master
[downloads]: https://packagist.org/packages/ramsey/collection
